/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SourceLamp
extends CopperBulbBlock
implements ILightable {
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.create((String)"light_level", (int)0, (int)15);

    public SourceLamp() {
        super(BlockBehaviour.Properties.of().lightLevel(p -> (Boolean)p.getValue((Property)LIT) != false ? (Integer)p.getValue((Property)LIGHT_LEVEL) : 0));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(15))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT, POWERED, LIGHT_LEVEL});
    }

    @Override
    public void onLight(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats augments, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)rayTraceResult;
            BlockState state = (BlockState)world.getBlockState(blockHitResult.getBlockPos()).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.min(Math.max(0, 15 - augments.getBuffCount(AugmentDampen.INSTANCE)), 15)));
            world.setBlock(blockHitResult.getBlockPos(), state, 3);
        }
    }

    protected int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Boolean)pLevel.getBlockState(pPos).getValue((Property)LIT) != false ? (Integer)pState.getValue((Property)LIGHT_LEVEL) : 0;
    }
}

